
#ifndef LLF_AESCCM_version_H
#define LLF_AESCCM_version_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS_version.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  02 Oct. 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains the prototype of LLF_AESCCM_GetVersion function.
   *
   *  \version LLF_AESCCM_version.h#1:incl:1
   *  \author R.Levin
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines ******************************/

/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************ Structs  ******************************/

/************************ Public Variables **********************/

/************************ Public Functions **********************/

/**
 * @brief This API returns the LLF AESCCM version.
 *
 * The version contains the following:
 *
 * - component string - a string describing the nature of the release.
 * - release type : CRYS_DEFS_HW_ENGINE_TYPE 
 * - major , minor , sub , internal - the release digits.
 *
 * Each component: CRYS , LLF machines receives this database. 
 *
 * @param[in] version_ptr - a pointer to the version structure.
 *
 */

 void  LLF_AESCCM_GetVersion(CRYS_ComponentVersion_t *version_ptr);


#ifdef __cplusplus
}
#endif

#endif

